<?php

namespace App\Exports;

use App\Models\Rolepengeluaran;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;

class PengeluaranExport implements FromView
{

    protected $tgl1;
    protected $tgl2;

    function __construct($tgl1, $tgl2)
    {
        $this->tgl1 = $tgl1;
        $this->tgl2 = $tgl2;
    }

    public function  view(): View
    {
        $data = [
            'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($this->tgl1)),
            'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($this->tgl2)),
        ];
        $pengeluaran = Rolepengeluaran::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $this->tgl1)
            ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $this->tgl2)
            ->get();
        return view('admin.laporan.export_pengeluaran', [
            'pengeluaran' => $pengeluaran,
            'no' => 1,
            'data' =>  $data,
        ]);
    }
}
